#!/bin/sh
LANG=C

Hdr=ZFITS.HDR
File=ZCORR.HDR
Tmp=ZFITS_tmp.HDR

URL='http://ztcs.sao.ru:8088'
User=guest
Passwd=guest
Method='Telescope.getStatusString'
Param='TelHAcorr TelDeclcorr HdwHAcorr HdwDeclcorr'

if ping -c 1 -W 1 ztcs >/dev/null 2>&1; then
  eval `xmlrpc "$URL" "$Method" "$Param" -username=$User -password=$Passwd | \
   tail -1 | tr -d "'" | sed 's/^String: //' | tr ' ' '\n'`

  echo "TELHACOR=              $TelHAcorr                                                      "|dd bs=80 count=1 2>/dev/null   >$File
  echo "TELDECOR=              $TelDeclcorr                                                      "|dd bs=80 count=1 2>/dev/null >>$File
  echo "HDWHACOR=              $HdwHAcorr                                                      "|dd bs=80 count=1 2>/dev/null   >>$File
  echo "HDWDECOR=              $HdwDeclcorr                                                      "|dd bs=80 count=1 2>/dev/null >>$File

  if [ -w $Hdr ]; then
    dd if=$Hdr bs=80 count=30 2>/dev/null | cat - $File >$Tmp
    touch -r $Hdr $Tmp
    mv $Tmp $Hdr
  fi
fi
