#!/usr/bin/python
import sys, re, socket, os
from datetime import datetime
from xmlrpclib import ServerProxy, Boolean, ProtocolError, Fault, Error

# Create an object to represent our server.
server_url = "http://user:ztcs@ztcs.sao.ru:8088"    # networked XML-RPC server
server = ServerProxy(server_url)
print "Zeiss TCS URL: " + server_url
try:
    print "Zeiss TCS Network Connection: "+str(server.Server.echo())
except socket.error, serr:
    print "Zeiss TCS Network Error: %s" % serr[1]
    sys.exit(1)
# read file argument
filename="ztcs_log.txt"
if len(sys.argv) >1:
	filename=sys.argv[1]
new=not os.access(filename, os.F_OK)
file=open(filename,"a")
if new:
	print >> file,"UTC_Date   UTC_Time STime        RA_cat       DEC_cat      Epoch  TelAppRA     TelAppDec    TelObsHA     TelObsAzim    TelObsZD     Obj_Name"
reqst = "TelMeanSTstr ObjMeanRAstr	 ObjMeanDeclstr Epoch TelAppRAstr TelAppDeclstr TelObsHAstr TelObsAzimstr TelObsZDstr ObjName"
# print data Call the XML-RPC server and get our results.
dt = datetime.utcnow()
s = dt.strftime("%Y-%m-%d %H:%M:%S ")
try:
    repl = re.split("\s+",server.Telescope.getStatusString(reqst))    
    for i in range(0,len(repl)):
		ll = str(repl[i]).split("=")
		s = s + str(ll[1]) + " "
	
except socket.error, serr:
    print "Network Error: %s" % serr[1]
except ProtocolError, err:
    print "A protocol error occurred"
    print "URL: %s" % err.url
    print "HTTP/HTTPS headers: %s" % err.headers
    print "Error code: %d" % err.errcode
    print "Error message: %s" % err.errmsg
except Fault, err:
    print "A fault occurred"
    print "Fault code: %d" % err.faultCode
    print "Fault string: %s" % err.faultString
except Error, v:
    print "ERROR", v
print >> file, s
