#!/usr/bin/python
# Input&Show somewhat position (HA/Decl or Az/ZD)  
# Args examples:
#    23:58:01 +12:34:56 
#    HA=23:58:01 Decl=+12:34:56
#    Az=359:00:00 ZD=05:00:00 

import sys, re, socket
from xmlrpclib import ServerProxy, ProtocolError, Fault, Error

# Create an object to represent our server.
server_url = "http://user:ztcs@ztcs.sao.ru:8088"    # networked XML-RPC server
server = ServerProxy(server_url)
print "Zeiss TCS URL: " + server_url
try:
    print "Zeiss TCS Network Connection: "+str(server.Server.echo())
except socket.error, serr:
    print "Zeiss TCS Network Error: %s" % serr[1]
    sys.exit(1)

# Call the XML-RPC server and get our results.
# Default request (for no args):
#reqst = "Az=180:00:00.0 ZD=+03:00:00"
reqst0 = "HA=00:00:00.0 Decl=+45:00:00.0"
#Parse arguments, if they are present
if len(sys.argv) > 1:
    reqst0 = ""
    for i in range(1,len(sys.argv)):
        if i==1 and sys.argv[i].find("=")<1:
            reqst0 += "HA="+sys.argv[i]+" "
        elif i==2 and sys.argv[i].find("=")<1:
            reqst0 += "Decl="+sys.argv[i]+" "
        else:
            reqst0 += sys.argv[i]+" "

try:   
    for rev in "Reverse=No","Reverse=Yes":
        reqst = reqst0+" "+rev
        if(server.Telescope.setupObject(reqst)):
            print "Telescope.setupObject("+reqst+") - Ok!"
            reqst = "InpObsAzstr InpObsZDstr InpObsHAstr InpObsRAstr InpObsDeclstr InpRevers InpEncHAstr InpEncDeclstr InpExposure InpAppRAstr InpAppDeclstr InpMeanRAstr InpMeanDeclstr InpEpoch InpMJD"
            repl = re.split("\s+",server.Telescope.getStatusString(reqst))
            for i in range(0,len(repl)):
                print "\t"+repl[i]
        else:
            print "Telescope.setupObject("+reqst+") - Wrong!"

except socket.error, serr:
    print "Network Error: %s" % serr[1]
except ProtocolError, err:
    print "A protocol error occurred"
    print "URL: %s" % err.url
    print "HTTP/HTTPS headers: %s" % err.headers
    print "Error code: %d" % err.errcode
    print "Error message: %s" % err.errmsg
except Fault, err:
    print "A fault occurred"
    print "Fault code: %d" % err.faultCode
    print "Fault string: %s" % err.faultString
except Error, v:
    print "ERROR", v
