#!/usr/bin/python
import sys, re, socket
from xmlrpclib import ServerProxy, ProtocolError, Fault, Error

# Create an object to represent our server.
server_url = "http://user:ztcs@ztcs.sao.ru:8088"    # networked XML-RPC server
server = ServerProxy(server_url)
print "Zeiss TCS URL: " + server_url
try:
    print "Zeiss TCS Network Connection: "+str(server.Server.echo())
except socket.error, serr:
    print "Zeiss TCS Network Error: %s" % serr[1]
    sys.exit(1)

# Call the XML-RPC server and get our results.
try:
    print "Server.info: "+server.Server.info()
    print "Telescope.getStatusString:"
#    reqst = "Status  TelMeanSTstr ObjMeanDeclstr Epoch"
    reqst = "Status  TelObsHAstr  TelObsDeclstr"
    repl = re.split("\s+",server.Telescope.getStatusString(reqst))
    print "\t"+repl[0]
#    ra = repl[1].split('=')[1]
    ha = repl[1].split('=')[1]
    dec = repl[2].split('=')[1]
#    epoch = repl[3].split('=')[1]
#    reqst = "RA="+ra+" Decl="+dec+" Epoch="+epoch
    reqst = "HA="+ha+" Decl="+dec
    if(server.Telescope.setupObject(reqst)):
        print "Telescope.setupObject("+reqst+") - Ok!"
        if(server.Telescope.slewToObject()):
            print "Telescope.slewToObject() - Ok!"
        else:
            print "Telescope.slewToObject() - Failed!"
    else:
        print "Telescope.setupObject("+reqst+") - Wrong!"

except socket.error, serr:
    print "Network Error: %s" % serr[1]
except ProtocolError, err:
    print "A protocol error occurred"
    print "URL: %s" % err.url
    print "HTTP/HTTPS headers: %s" % err.headers
    print "Error code: %d" % err.errcode
    print "Error message: %s" % err.errmsg
except Fault, err:
    print "A fault occurred"
    print "Fault code: %d" % err.faultCode
    print "Fault string: %s" % err.faultString
except Error, v:
    print "ERROR", v
