#!/bin/sh
LANG=C

URL='http://ztcs.sao.ru:8088'
User=guest
Passwd=guest
Method='Telescope.getStatusString'
Param='Status TelMeanSTstr TelAppRAstr TelAppDeclstr TelObsDecl TelObsAzimstr TelObsZDstr ObjMeanRAstr ObjMeanDeclstr ObjEpoch TelHAcorr TelDeclcorr HdwHAcorr HdwDeclcorr '

#echo "Content-type: text/plain"
#echo

if ping -c 1 -W 1 ztcs >/dev/null 2>&1; then
  if nc -z ztcs 80 >/dev/null 2>&1; then
    eval `curl "http://ztcs.sao.ru/ZEISS/focval.dat" 2>/dev/null | tr -d ' '`
  else
    FOCUS=0.0
  fi
  if nc -z ztcs 8088 >/dev/null 2>&1; then
    eval `xmlrpc "$URL" "$Method" "$Param" -username=$User -password=$Passwd | \
     tail -1 | tr -d "'" | sed 's/^String: //' | tr ' ' '\n'`
    echo "ZeissTCS=\"On\""
    echo "TelState=\"$Status\""
    echo "M_time=\""`date "+%T\""`
    echo "S_time=\"$TelMeanSTstr\""
    echo "UTC=\""`date -u "+%T\""`
    echo "CurrRA=\"$TelAppRAstr\""
    echo "CurrDecl=\"$TelAppDeclstr\""
    echo "SrcRA=\"$ObjMeanRAstr\""
    echo "SrcDecl=\"$ObjMeanDeclstr\""
    echo "SrcEpoch=\"$ObjEpoch\""
    echo "$TelObsDecl  $TelHAcorr $TelDeclcorr $HdwHAcorr $HdwDeclcorr" | \
    awk '{printf("ShiftRA=\"%.2f\"\nShiftDecl=\"%.1f\"\n", -($2+$4/cos($1/3600/180*3.1415926)), $3+$5);}'
    echo "CurAzim=\"$TelObsAzimstr\""
    echo "CurZenD=\"$TelObsZDstr\""
    echo "ValAzim=\"$TelObsAzimstr\""
    echo "ValZenD=\"$TelObsZDstr\""
    echo "ValFoc=\"$FOCUS\""
  else
    echo "ZeissTCS=\"Off\""
  fi
else
    echo "ZeissTCS=\"Off\""
fi
