#!/usr/bin/python
# Zeiss-1000 telescope correction
# Usage:
#     ztcs_tel_corr.py RA_corr  Decl_corr  [User Passwd]
#                     (arcsec)  (arcsec)
# Args example:
#     ztcs_tel_corr.py  0.1  -0.2

import sys, time, string, re, socket
from xmlrpclib import ServerProxy, ProtocolError, Fault, Error

user = "user"    # default user name
passwd = "ztcs"  # default pasword
host = "ztcs"    # TCS server name
server_url = "http://user:ztcs@ztcs.sao.ru:8088" # default XML-RPC server URL

#Parse arguments, if they are present
if len(sys.argv) > 2:
    ra_cor = sys.argv[1]
    dec_cor = sys.argv[2]
    if len(sys.argv) > 3:
	user = sys.argv[3]
	if len(sys.argv) == 4:
	    print "Password for user "+user+" needs!"
	    sys.exit(1)
	passwd = sys.argv[4]
else:
    print "Wrong arguments!"
    print "Usage: "+sys.argv[0]+" RA_corr  Dwc_corr  [User Passwd]"
    sys.exit(1)

# Create an object to represent our server.
server_url = "http://"+user+":"+passwd+"@"+host+".sao.ru:8088" # XML-RPC server URL
server = ServerProxy(server_url)
#print "Zeiss TCS URL: " + server_url
try:
    repl = server.Server.echo()
except socket.error, serr:
    print "Zeiss TCS Network Error: %s" % serr[1]
    sys.exit(1)

try:
    hacorr = -float(ra_cor)/15.0
    hacorr = int(hacorr*10000)/10000.0
    decorr = float(dec_cor)
except ValueError:
    print "Wrong correction argument!"
    sys.exit(1)


reqst = "TelHAadd="+str(hacorr)+" TelDecladd="+str(decorr)
try:
    repl = server.Telescope.getStatusString("Status")
    l = re.split("=",repl)
    stat = l[1]
    if stat == "Tracking":
	if(server.Telescope.setCorr(reqst)):
	    print "Ok!"
	else:
	    print "Telescope.setCorr() request - Wrong!"
    else:
	print "Telescope not in 'Tracking' mode!"

except socket.error, serr:
    print "Network Error: %s" % serr[1]
except ProtocolError, err:
    print "A protocol error occurred"
    print "URL: %s" % err.url
    print "HTTP/HTTPS headers: %s" % err.headers
    print "Error code: %d" % err.errcode
    print "Error message: %s" % err.errmsg
except Fault, err:
    print "A fault occurred"
    print "Fault code: %d" % err.faultCode
    print "Fault string: %s" % err.faultString
except Error, v:
    print "ERROR", v


