#!/usr/bin/python
import sys, re, socket
from xmlrpclib import ServerProxy, Boolean, ProtocolError, Fault, Error

# Create an object to represent our server.
server_url = "http://guest:guest@ztcs.sao.ru:8088"    # networked XML-RPC server
server = ServerProxy(server_url)
print "Zeiss TCS URL: " + server_url
try:
    print "Zeiss TCS Network Connection: "+str(server.Server.echo())
except socket.error, serr:
    print "Zeiss TCS Network Error: %s" % serr[1]
    sys.exit(1)

# Call the XML-RPC server and get our results.
try:
    print "Server.info: "+server.Server.info()
    print "Telescope.isSimulator: "+str(server.Telescope.isSimulator())
    print "Telescope.getStatusString:"
    reqst = "Status  TelMeanSTstr ObjName ObjMeanRAstr TelAppRAstr TelObsRAstr TelObsHAstr TelHAcorr TelEncHAstr TelRevers ObjMeanDeclstr TelAppDeclstr TelObsDeclstr TelDeclcorr TelEncDeclstr TelObsAzimstr TelObsZDstr InpExposure ObjExposure TelExposure"
    repl = re.split("\s+",server.Telescope.getStatusString(reqst))
    for i in range(0,len(repl)):
        print "\t"+repl[i]
except socket.error, serr:
    print "Network Error: %s" % serr[1]
except ProtocolError, err:
    print "A protocol error occurred"
    print "URL: %s" % err.url
    print "HTTP/HTTPS headers: %s" % err.headers
    print "Error code: %d" % err.errcode
    print "Error message: %s" % err.errmsg
except Fault, err:
    print "A fault occurred"
    print "Fault code: %d" % err.faultCode
    print "Fault string: %s" % err.faultString
except Error, v:
    print "ERROR", v
